//	m4kit.h  -  main library include file
//
//	This is a part of the MetaKit library.
//	Copyright (c) 1996 Meta Four Software.
//	All rights reserved.
/////////////////////////////////////////////////////////////////////////////

#ifndef __M4KIT_H__
#define __M4KIT_H__

/////////////////////////////////////////////////////////////////////////////
//
//	TITLE
//								  
//		The MetaKit Library, by Jean-Claude Wippler, Meta Four Software, NL.
//		
//	DESCRIPTION
//								  
//		Structured data storage with commit / rollback and on-demand loading.
//	
//	DISCLAIMER
//
//		The author makes no warranties, either expressed or implied, with
//		respect to this software, its quality, performance, merchantability,
//		or fitness for any particular purpose. This software is distributed
//		AS IS. The user of this software assumes all risks as to its quality
//		and performance. In no event shall the author be liable for any
//		direct, indirect or consequential damages, even if the author has
//		been advised as to the possibility of such damages.
//			  
//	ACKNOWLEDGEMENTS
//								                                          
//		To Liesbeth and Myra, for making this possible.
//
//		Thanks to Alexander Stigsen and Kirill Denisenko for their feedback.
//								 
//	Do you have any suggestions, ideas, fixes? All valuable feedback will be
//	rewarded with an honorable mention in this section. It's up to *YOU* now.
//
/////////////////////////////////////////////////////////////////////////////
//
//	NAMING CONVENTIONS		  PREFIX	REMARKS
//								
//		Compile time options	q4_		Always defined as 1 or 0, capitalized
//		Preprocessor defines	d4_		Use with "#ifdef" or "#if defined()"
//	
//		Classes					c4_		Described at start of each header
//		Type definitions		t4_     Not frequently used
//		Enumerations			n4_		Not always named
//	
//		Global functions		f4_     These are rarely defined
//		Global variables		g4_		Avoided wherever possible
//
//		Member functions				Start in uppercase
//		Instance variables		_		And start in lowercase
//		Static members			_		And start in uppercase
//
//		Local variable names			Start in lowercase
//		Formal parameter names			Start lowercase, end with underscore
//
/////////////////////////////////////////////////////////////////////////////

	// current release = 100 * major + 10 * minor + maintenance
#define d4_MetaKitLibraryVersion	140		// November 1, 1996

#include "k4conf.h" 	// configuration, compatibility, elementary types
#include "k4view.h"		// views, cursors, rows, properties, storage

/////////////////////////////////////////////////////////////////////////////

#endif
